/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.pool.TimeoutScheduler;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.NotificationResponse;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005s!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0006)pgR<'/Z*R\u0019\u000e{gN\\3di&|gN\u0003\u0002\u0004\t\u0005Q\u0001o\\:uOJ,7/\u001d7\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"A\u0003bgft7M\u0003\u0002\n\u0015\u0005AQ.Y;sS\u000eLwN\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u000by\u0012aB\"pk:$XM]\u000b\u0002AA\u0011\u0011EK\u0007\u0002E)\u00111\u0005J\u0001\u0007CR|W.[2\u000b\u0005\u00152\u0013AC2p]\u000e,(O]3oi*\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\u0012#AC!u_6L7\rT8oO\"1Q&\u0005Q\u0001\u000e\u0001\n\u0001bQ8v]R,'\u000f\t\u0005\b_E\u0011\r\u0011\"\u00021\u0003A\u0019VM\u001d<feZ+'o]5p].+\u00170F\u00012\u001f\u0005\u0011\u0014%A\u001a\u0002\u001dM,'O^3s?Z,'o]5p]\"1Q'\u0005Q\u0001\u000eE\n\u0011cU3sm\u0016\u0014h+\u001a:tS>t7*Z=!\u0011\u001d9\u0014C1A\u0005\u0006a\n1\u0001\\8h+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000f\u0002\u0007\u0019><w-\u001a:\t\r\t\u000b\u0002\u0015!\u0004:\u0003\u0011awn\u001a\u0011\t\u000f\u0011\u000b\u0012\u0013!C\u0001\u000b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012A\u0012\u0016\u0003\u000f.\u0003\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8oW\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u0003%)hn\u00195fG.,GM\u0003\u0002R-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Ms%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q+EI\u0001\n\u00031\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001XU\tA6\n\u0005\u0002Z96\t!L\u0003\u0002\\\t\u000511m\u001c7v[:L!!\u0018.\u0003+\r{G.^7o\u000b:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"9q,EI\u0001\n\u0003\u0001\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001bU\t\u00117\n\u0005\u0002ZG&\u0011AM\u0017\u0002\u0016\u0007>dW/\u001c8EK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0011\u001d1\u0017#%A\u0005\u0002\u001d\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u00015+\u0005%\\\u0005C\u00016r\u001b\u0005Y'B\u00017n\u0003\u001d\u0019\u0007.\u00198oK2T!A\\8\u0002\u000b9,G\u000f^=\u000b\u0003A\f!![8\n\u0005I\\'AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\biF\t\n\u0011\"\u0001v\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\taO\u000b\u0002x\u0017B\u0011\u0001P_\u0007\u0002s*\u0011QEF\u0005\u0003wf\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0007\tI\u0011\u0001!`\n\byRq\u0018\u0011BA\b!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0003\u0003\u0015\u0019w\u000eZ3d\u0013\u0011\t9!!\u0001\u00039A{7\u000f^4sKN\u000bFjQ8o]\u0016\u001cG/[8o\t\u0016dWmZ1uKB\u0019\u0001*a\u0003\n\u0007\u00055AA\u0001\u0006D_:tWm\u0019;j_:\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+!\u0011\u0001\u00029p_2LA!!\u0007\u0002\u0014\t\u0001B+[7f_V$8k\u00195fIVdWM\u001d\u0005\n\u0003;a(\u0011!Q\u0001\n\u001d\u000bQbY8oM&<WO]1uS>t\u0007\"CA\u0011y\n\u0005\t\u0015!\u0003Y\u0003=)gnY8eKJ\u0014VmZ5tiJL\b\"CA\u0013y\n\u0005\t\u0015!\u0003c\u0003=!WmY8eKJ\u0014VmZ5tiJL\b\"CA\u0015y\n\u0005\t\u0015!\u0003j\u0003\u00159'o\\;q\u0011)\ti\u0003 BC\u0002\u0013\r\u0011qF\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012a\u001e\u0005\n\u0003ga(\u0011!Q\u0001\n]\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0011\u0019YB\u0010\"\u0001\u00028Qa\u0011\u0011HA\u001e\u0003{\ty$!\u0011\u0002DA\u0011\u0001\u0003 \u0005\n\u0003;\t)\u0004%AA\u0002\u001dC\u0011\"!\t\u00026A\u0005\t\u0019\u0001-\t\u0013\u0005\u0015\u0012Q\u0007I\u0001\u0002\u0004\u0011\u0007\"CA\u0015\u0003k\u0001\n\u00111\u0001j\u0011%\ti#!\u000e\u0011\u0002\u0003\u000fq\u000fC\u0005\u0002Hq\u0014\r\u0011\"\u0004\u0002J\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005-\u0003cA@\u0002N%!\u0011qJA\u0001\u0005m\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\"A\u00111\u000b?!\u0002\u001b\tY%\u0001\nd_:tWm\u0019;j_:D\u0015M\u001c3mKJ\u0004\u0003\"CA,y\n\u0007IQBA-\u00031\u0019WO\u001d:f]R\u001cu.\u001e8u+\t\tY\u0006E\u0002\u0016\u0003;J1!a\u0018\u0017\u0005\u0011auN\\4\t\u0011\u0005\rD\u0010)A\u0007\u00037\nQbY;se\u0016tGoQ8v]R\u0004\u0003\"CA4y\n\u0007IQBA5\u0003e\u0001(/\u001a9be\u0016$7\u000b^1uK6,g\u000e^:D_VtG/\u001a:\u0016\u0005\u0005-\u0004cA\u0011\u0002n%\u0019\u0011q\u000e\u0012\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\t\u0019\b Q\u0001\u000e\u0005-\u0014A\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ\u0004\u0003\"CA<y\n\u0007I\u0011BA=\u0003=\u0001\u0018M]1nKR,'o\u0015;biV\u001cXCAA>!!\ti(a\"\u0002\f\u0006-UBAA@\u0015\u0011\t\t)a!\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0011\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0006}$a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003\u001b\u000bYJ\u0004\u0003\u0002\u0010\u0006]\u0005cAAI-5\u0011\u00111\u0013\u0006\u0004\u0003+s\u0011A\u0002\u001fs_>$h(C\u0002\u0002\u001aZ\ta\u0001\u0015:fI\u00164\u0017\u0002BAO\u0003?\u0013aa\u0015;sS:<'bAAM-!A\u00111\u0015?!\u0002\u0013\tY(\u0001\tqCJ\fW.\u001a;feN#\u0018\r^;tA!I\u0011q\u0015?C\u0002\u0013%\u0011\u0011V\u0001\u0011a\u0006\u00148/\u001a3Ti\u0006$X-\\3oiN,\"!a+\u0011\u0011\u0005u\u0014qQAF\u0003[\u00032\u0001EAX\u0013\r\t\tL\u0001\u0002\u0018!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bj\u001c7eKJD\u0001\"!.}A\u0003%\u00111V\u0001\u0012a\u0006\u00148/\u001a3Ti\u0006$X-\\3oiN\u0004\u0003\"CA]y\u0002\u0007I\u0011BA^\u00035\tW\u000f\u001e5f]RL7-\u0019;fIV\u0011\u0011Q\u0018\t\u0004+\u0005}\u0016bAAa-\t9!i\\8mK\u0006t\u0007\"CAcy\u0002\u0007I\u0011BAd\u0003E\tW\u000f\u001e5f]RL7-\u0019;fI~#S-\u001d\u000b\u0005\u0003\u0013\fy\rE\u0002\u0016\u0003\u0017L1!!4\u0017\u0005\u0011)f.\u001b;\t\u0015\u0005E\u00171YA\u0001\u0002\u0004\ti,A\u0002yIEB\u0001\"!6}A\u0003&\u0011QX\u0001\u000fCV$\b.\u001a8uS\u000e\fG/\u001a3!\u0011%\tI\u000e b\u0001\n\u0013\tY.\u0001\td_:tWm\u0019;j_:4U\u000f^;sKV\u0011\u0011Q\u001c\t\u0006q\u0006}\u0017\u0011B\u0005\u0004\u0003CL(a\u0002)s_6L7/\u001a\u0005\t\u0003Kd\b\u0015!\u0003\u0002^\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8GkR,(/\u001a\u0011\t\u0013\u0005%H\u00101A\u0005\n\u0005m\u0016a\u0003:fG\u0016tG/\u0012:s_JD\u0011\"!<}\u0001\u0004%I!a<\u0002\u001fI,7-\u001a8u\u000bJ\u0014xN]0%KF$B!!3\u0002r\"Q\u0011\u0011[Av\u0003\u0003\u0005\r!!0\t\u0011\u0005UH\u0010)Q\u0005\u0003{\u000bAB]3dK:$XI\u001d:pe\u0002B\u0011\"!?}\u0005\u0004%I!a?\u0002+E,XM]=Qe>l\u0017n]3SK\u001a,'/\u001a8dKV\u0011\u0011Q \t\u0006C\u0005}(1A\u0005\u0004\u0005\u0003\u0011#aD!u_6L7MU3gKJ,gnY3\u0011\u000bU\u0011)A!\u0003\n\u0007\t\u001daC\u0001\u0004PaRLwN\u001c\t\u0006q\u0006}'1\u0002\t\u0004\u0011\n5\u0011b\u0001B\b\t\tY\u0011+^3ssJ+7/\u001e7u\u0011!\u0011\u0019\u0002 Q\u0001\n\u0005u\u0018AF9vKJL\bK]8nSN,'+\u001a4fe\u0016t7-\u001a\u0011\t\u0013\t]A\u00101A\u0005\n\te\u0011\u0001D2veJ,g\u000e^)vKJLXC\u0001B\u000e!\u0015)\"Q\u0001B\u000f!\u0019\u0011yB!\n\u0003*5\u0011!\u0011\u0005\u0006\u0004\u0005G!\u0011aB4f]\u0016\u0014\u0018\r\\\u0005\u0005\u0005O\u0011\tC\u0001\tNkR\f'\r\\3SKN,H\u000e^*fiB!!1\u0006B\u001b\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012a\u00022bG.,g\u000e\u001a\u0006\u0004\u0005g\u0011\u0011\u0001C7fgN\fw-Z:\n\t\t]\"Q\u0006\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c7v[:$\u0015\r^1\t\u0013\tmB\u00101A\u0005\n\tu\u0012\u0001E2veJ,g\u000e^)vKJLx\fJ3r)\u0011\tIMa\u0010\t\u0015\u0005E'\u0011HA\u0001\u0002\u0004\u0011Y\u0002\u0003\u0005\u0003Dq\u0004\u000b\u0015\u0002B\u000e\u00035\u0019WO\u001d:f]R\fV/\u001a:zA!I!q\t?A\u0002\u0013%!\u0011J\u0001\u0019GV\u0014(/\u001a8u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$XC\u0001B&!\u0015)\"QAAW\u0011%\u0011y\u0005 a\u0001\n\u0013\u0011\t&\u0001\u000fdkJ\u0014XM\u001c;Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R|F%Z9\u0015\t\u0005%'1\u000b\u0005\u000b\u0003#\u0014i%!AA\u0002\t-\u0003\u0002\u0003B,y\u0002\u0006KAa\u0013\u00023\r,(O]3oiB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\t\u0005\n\u00057b\b\u0019!C\u0005\u0005;\nqA^3sg&|g.\u0006\u0002\u0003`A!!\u0011\rB3\u001b\t\u0011\u0019G\u0003\u0002(\t%!!q\rB2\u0005\u001d1VM]:j_:D\u0011Ba\u001b}\u0001\u0004%IA!\u001c\u0002\u0017Y,'o]5p]~#S-\u001d\u000b\u0005\u0003\u0013\u0014y\u0007\u0003\u0006\u0002R\n%\u0014\u0011!a\u0001\u0005?B\u0001Ba\u001d}A\u0003&!qL\u0001\tm\u0016\u00148/[8oA!I!q\u000f?A\u0002\u0013%!\u0011P\u0001\u0010]>$\u0018NZ=MSN$XM\\3sgV\u0011!1\u0010\t\u0007\u0005{\u0012yHa!\u000e\u0003\u0011J1A!!%\u0005Q\u0019u\u000e]=P]^\u0013\u0018\u000e^3BeJ\f\u0017\u0010T5tiB9QC!\"\u0003\n\u0006%\u0017b\u0001BD-\tIa)\u001e8di&|g.\r\t\u0005\u0005W\u0011Y)\u0003\u0003\u0003\u000e\n5\"\u0001\u0006(pi&4\u0017nY1uS>t'+Z:q_:\u001cX\rC\u0005\u0003\u0012r\u0004\r\u0011\"\u0003\u0003\u0014\u0006\u0019bn\u001c;jMfd\u0015n\u001d;f]\u0016\u00148o\u0018\u0013fcR!\u0011\u0011\u001aBK\u0011)\t\tNa$\u0002\u0002\u0003\u0007!1\u0010\u0005\t\u00053c\b\u0015)\u0003\u0003|\u0005\u0001bn\u001c;jMfd\u0015n\u001d;f]\u0016\u00148\u000f\t\u0005\n\u0005;c\b\u0019!C\u0005\u0005?\u000b1\"];fef\u0014Vm];miV\u0011!\u0011\u0015\t\u0006+\t\u0015!1\u0002\u0005\n\u0005Kc\b\u0019!C\u0005\u0005O\u000bq\"];fef\u0014Vm];mi~#S-\u001d\u000b\u0005\u0003\u0013\u0014I\u000b\u0003\u0006\u0002R\n\r\u0016\u0011!a\u0001\u0005CC\u0001B!,}A\u0003&!\u0011U\u0001\rcV,'/\u001f*fgVdG\u000f\t\u0005\b\u0005ccH\u0011\tBZ\u00039)g/\u001a8u\u0019>|\u0007o\u0012:pkB,\u0012!\u001b\u0005\b\u0005ocH\u0011AA^\u0003=I7OU3bIf4uN])vKJL\bb\u0002B^y\u0012\u0005!QX\u0001\bG>tg.Z2u+\t\u0011y\fE\u0003y\u0005\u0003\fI!C\u0002\u0003Df\u0014aAR;ukJ,\u0007b\u0002Bdy\u0012\u0005#QX\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bb\u0002Bfy\u0012\u0005#QZ\u0001\n_:$\u0016.\\3pkR,\"!!3\t\u000f\tEG\u0010\"\u0011\u0002<\u0006Y\u0011n]\"p]:,7\r^3e\u0011\u001d\u0011)\u000e C\u0001\u0005/\f\u0011\u0003]1sC6,G/\u001a:Ti\u0006$Xo]3t+\t\u0011I\u000e\u0005\u0005\u0003\\\n\u0005\u00181RAF\u001b\t\u0011iN\u0003\u0003\u0003`\u0006\r\u0015!C5n[V$\u0018M\u00197f\u0013\u0011\u0011\u0019O!8\u0003\u00075\u000b\u0007\u000fC\u0004\u0003hr$\tE!;\u0002\u0013M,g\u000eZ)vKJLH\u0003\u0002Bv\u0005[\u0004R\u0001\u001fBa\u0005\u0017A\u0001Ba<\u0003f\u0002\u0007\u00111R\u0001\u0006cV,'/\u001f\u0005\b\u0005gdH\u0011\tB{\u0003U\u0019XM\u001c3Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R$bAa;\u0003x\ne\b\u0002\u0003Bx\u0005c\u0004\r!a#\t\u0015\tm(\u0011\u001fI\u0001\u0002\u0004\u0011i0\u0001\u0004wC2,Xm\u001d\t\u0007\u0005\u007f\u001cIaa\u0004\u000f\t\r\u00051Q\u0001\b\u0005\u0003#\u001b\u0019!C\u0001\u0018\u0013\r\u00199AF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019Ya!\u0004\u0003\u0007M+\u0017OC\u0002\u0004\bY\u00012!FB\t\u0013\r\u0019\u0019B\u0006\u0002\u0004\u0003:L\bbBB\fy\u0012\u00053\u0011D\u0001\b_:,%O]8s)\u0011\tIma\u0007\t\u0011\ru1Q\u0003a\u0001\u0007?\t\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\t}8\u0011E\u0005\u0005\u0007G\u0019iAA\u0005UQJ|w/\u00192mK\"91q\u0005?\u0005\u0002\u0005m\u0016A\u00045bgJ+7-\u001a8u\u000bJ\u0014xN\u001d\u0005\b\u0007WaH\u0011BB\u0017\u0003E\u0019X\r^#se>\u0014xJ\u001c$viV\u0014Xm\u001d\u000b\u0005\u0003\u0013\u001cy\u0003\u0003\u0005\u00042\r%\u0002\u0019AB\u0010\u0003\u0005)\u0007bBB\u001by\u0012\u00053qG\u0001\u0010_:\u0014V-\u00193z\r>\u0014\u0018+^3ssR\u0011\u0011\u0011\u001a\u0005\b\u0007/aH\u0011IB\u001e)\u0011\tIm!\u0010\t\u0011\r}2\u0011\ba\u0001\u0007\u0003\n\u0011!\u001c\t\u0005\u0005W\u0019\u0019%\u0003\u0003\u0004F\t5\"\u0001D#se>\u0014X*Z:tC\u001e,\u0007bBB%y\u0012\u000531J\u0001\u0012_:\u001cu.\\7b]\u0012\u001cu.\u001c9mKR,G\u0003BAe\u0007\u001bB\u0001ba\u0010\u0004H\u0001\u00071q\n\t\u0005\u0005W\u0019\t&\u0003\u0003\u0004T\t5\"AF\"p[6\fg\u000eZ\"p[BdW\r^3NKN\u001c\u0018mZ3\t\u000f\r]C\u0010\"\u0011\u0004Z\u0005\trN\u001c)be\u0006lW\r^3s'R\fG/^:\u0015\t\u0005%71\f\u0005\t\u0007\u007f\u0019)\u00061\u0001\u0004^A!!1FB0\u0013\u0011\u0019\tG!\f\u0003-A\u000b'/Y7fi\u0016\u00148\u000b^1ukNlUm]:bO\u0016Dqa!\u001a}\t\u0003\u001a9'A\u0005p]\u0012\u000bG/\u0019*poR!\u0011\u0011ZB5\u0011!\u0019yda\u0019A\u0002\r-\u0004\u0003\u0002B\u0016\u0007[JAaa\u001c\u0003.\tqA)\u0019;b%><X*Z:tC\u001e,\u0007bBB:y\u0012\u00053QO\u0001\u0011_:\u0014vn\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!!3\u0004x!A1qHB9\u0001\u0004\u0019I\b\u0005\u0003\u0003,\rm\u0014\u0002BB?\u0005[\u0011QCU8x\t\u0016\u001c8M]5qi&|g.T3tg\u0006<W\rC\u0004\u0004\u0002r$Iaa!\u0002\u001dM,GoQ8mk6tG)\u0019;bgR!\u0011\u0011ZBC\u0011!\u00199ia A\u0002\r%\u0015aC2pYVlg\u000eR1uCN\u0004R!FBF\u0005SI1a!$\u0017\u0005\u0015\t%O]1z\u0011\u001d\u0019\t\n C!\u0007'\u000b\u0001d\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0011\tIm!&\t\u0011\r]5q\u0012a\u0001\u00073\u000bq!\\3tg\u0006<W\r\u0005\u0003\u0003,\rm\u0015\u0002BBO\u0005[\u0011Q#Q;uQ\u0016tG/[2bi&|g.T3tg\u0006<W\rC\u0004\u0004\"r$\tea)\u0002-=tgj\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016$B!!3\u0004&\"A1qSBP\u0001\u0004\u0011I\tC\u0004\u0004*r$\taa+\u0002-I,w-[:uKJtu\u000e^5gs2K7\u000f^3oKJ$B!!3\u0004.\"A1qVBT\u0001\u0004\u0011\u0019)\u0001\u0005mSN$XM\\3s\u0011\u001d\u0019\u0019\f C\u0001\u0007k\u000b\u0001$\u001e8sK\u001eL7\u000f^3s\u001d>$\u0018NZ=MSN$XM\\3s)\u0011\tIma.\t\u0011\r=6\u0011\u0017a\u0001\u0005\u0007Cqaa/}\t\u0003\u00199$\u0001\u000bdY\u0016\f'OT8uS\u001aLH*[:uK:,'o\u001d\u0005\b\u0007\u007fcH\u0011BBa\u0003)\u0019'/\u001a3f]RL\u0017\r\u001c\u000b\u0005\u0007\u0007\u001cy\r\u0005\u0003\u0004F\u000e-WBABd\u0015\u0011\u0019IM!\r\u0002\u0011\u0019\u0014xN\u001c;f]\u0012LAa!4\u0004H\n\t2I]3eK:$\u0018.\u00197NKN\u001c\u0018mZ3\t\u0011\rE7Q\u0018a\u0001\u0007'\fQ#Y;uQ\u0016tG/[2bi&|g.T3tg\u0006<W\r\u0005\u0003\u0003,\rU\u0017\u0002BBl\u0005[\u0011a$Q;uQ\u0016tG/[2bi&|gn\u00115bY2,gnZ3NKN\u001c\u0018mZ3\t\u0011\rmG\u0010)C\u0005\u0007;\fQC\\8u%\u0016\fG-\u001f$peF+XM]=FeJ|'\u000f\u0006\u0004\u0004`\u000e\u00158\u0011\u001e\t\u0004+\r\u0005\u0018bABr-\t9aj\u001c;iS:<\u0007\u0002CBt\u00073\u0004\r!a#\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\t\u0011\r-8\u0011\u001ca\u0001\u0003{\u000bAA]1dK\"91q\u001e?\u0005\u0002\rE\u0018a\u0007<bY&$\u0017\r^3JM&#\u0018j\u001d*fC\u0012Lhi\u001c:Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002J\u000eM\b\u0002CBt\u0007[\u0004\r!a#\t\u000f\r]H\u0010\"\u0003\u0004z\u0006ia/\u00197jI\u0006$X-U;fef$B!!3\u0004|\"A!q^B{\u0001\u0004\tY\tC\u0004\u0004\u0000r$I\u0001\"\u0001\u0002\u0019E,XM]=Qe>l\u0017n]3\u0016\u0005\t\r\u0001b\u0002C\u0003y\u0012%AqA\u0001\u0010g\u0016$\u0018+^3ssB\u0013x.\\5tKR!\u0011\u0011\u001aC\u0005\u0011!!Y\u0001b\u0001A\u0002\t%\u0011a\u00029s_6L7/\u001a\u0005\b\t\u001faH\u0011\u0002C\u0001\u0003E\u0019G.Z1s#V,'/\u001f)s_6L7/\u001a\u0005\b\t'aH\u0011\u0002C\u000b\u0003A1\u0017-\u001b7Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u0002J\u0012]\u0001\u0002\u0003C\r\t#\u0001\raa\b\u0002\u0003QDq\u0001\"\b}\t\u0013!y\"A\ntk\u000e\u001cW-\u001a3Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u0002J\u0012\u0005\u0002\u0002\u0003C\u0012\t7\u0001\rAa\u0003\u0002\rI,7/\u001e7u\u0011\u001d!9\u0003 C\u0005\tS\tQa\u001e:ji\u0016$B!!3\u0005,!A1q\u0013C\u0013\u0001\u0004!i\u0003\u0005\u0003\u0004F\u0012=\u0012\u0002\u0002C\u0019\u0007\u000f\u0014Qb\u00117jK:$X*Z:tC\u001e,\u0007b\u0002C\u001by\u0012\u0005CqG\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0012\u0005\n\twa\u0018\u0013!C!\t{\tqd]3oIB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!yDK\u0002\u0003~.\u0003")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final EventLoopGroup group;
    private final ExecutionContext executionContext;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger preparedStatementsCounter;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners;
    private Option<QueryResult> queryResult;
    private AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static EventLoopGroup $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public boolean isTimeouted() {
        return TimeoutScheduler.isTimeouted$((TimeoutScheduler)this);
    }

    public <A> Option<ScheduledFuture<?>> addTimeout(Promise<A> promise, Option<Duration> durationOption, ExecutionContext executionContext) {
        return TimeoutScheduler.addTimeout$((TimeoutScheduler)this, promise, durationOption, (ExecutionContext)executionContext);
    }

    public ScheduledFuture<?> schedule(Function0<BoxedUnit> block, Duration duration) {
        return TimeoutScheduler.schedule$((TimeoutScheduler)this, block, (Duration)duration);
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.inTransaction$((Connection)this, f, (ExecutionContext)executionContext);
    }

    public AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool() {
        return this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;
    }

    public void com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool_$eq(AtomicBoolean x$1) {
        this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool = x$1;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    private final AtomicInteger preparedStatementsCounter() {
        return this.preparedStatementsCounter;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    private HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    public Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners() {
        return this.notifyListeners;
    }

    private void notifyListeners_$eq(CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> x$1) {
        this.notifyListeners = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.group;
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onFailure((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.executionContext());
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1 & Serializable & scala.Serializable)c -> this, this.executionContext());
    }

    public void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.$conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query));
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        PreparedStatementMessage preparedStatementMessage;
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        PreparedStatementHolder holder = (PreparedStatementHolder)this.parsedStatements().getOrElseUpdate((Object)query, (Function0 & Serializable & scala.Serializable)() -> new PreparedStatementHolder(query, this.preparedStatementsCounter().incrementAndGet()));
        if (holder.paramsCount() != values.length()) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder.paramsCount(), values);
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder));
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])holder.columnDatas()))));
        if (holder.prepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        } else {
            holder.prepared_$eq(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (!this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().isCompleted()) {
            this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().failure(e);
            future = this.disconnect();
        } else {
            future = BoxedUnit.UNIT;
        }
        this.currentPreparedStatement().map((Function1 & Serializable & scala.Serializable)p -> this.parsedStatements().remove((Object)p.query()));
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1 & Serializable & scala.Serializable)result -> {
            this.succeedQueryPromise(result);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", new Object[]{m});
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        block0: {
            this.parameterStatus().put((Object)m.key(), (Object)m.value());
            if (!"server_version".equals(m.key())) break block0;
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.values())).size()];
        for (int x = 0; x < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.values())).size(); ++x) {
            Object object;
            ByteBuf buf = m.values()[x];
            if (buf == null) {
                object = null;
            } else {
                try {
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                    object = this.decoderRegistry.decode((ColumnData)columnType, buf, this.configuration.charset());
                }
                finally {
                    buf.release();
                }
            }
            items[x] = object;
        }
        ((MutableResultSet)this.currentQuery().get()).addRow(items);
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])m.columnDatas()))));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(PostgreSQLColumnData[] columnDatas) {
        this.currentPreparedStatement().foreach((Function1 & Serializable & scala.Serializable)holder -> {
            holder.columnDatas_$eq(columnDatas);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage = message;
        if (authenticationMessage instanceof AuthenticationOkMessage) {
            PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
            this.authenticated_$eq(true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (authenticationMessage instanceof AuthenticationChallengeCleartextMessage) {
            AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
            this.write(this.credential(authenticationChallengeCleartextMessage));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (authenticationMessage instanceof AuthenticationChallengeMD5) {
            AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
            this.write(this.credential(authenticationChallengeMD5));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)authenticationMessage);
        }
    }

    @Override
    public void onNotificationResponse(NotificationResponse message) {
        Iterator<Function1<NotificationResponse, BoxedUnit>> iterator = this.notifyListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().apply((Object)message);
        }
    }

    public void registerNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().add(listener);
    }

    public void unregisterNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().remove(listener);
    }

    public void clearNotifyListeners() {
        this.notifyListeners().clear();
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() == null || !this.configuration.password().isDefined()) {
            throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
        }
        return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (!this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
        }
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1 & Serializable & scala.Serializable)promise -> {
            PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", new Object[]{promise});
            return promise.failure(t);
        });
    }

    private void succeedQueryPromise(QueryResult result) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.success((Object)result));
    }

    private void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "{counter=", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToLong((long)this.currentCount())}));
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.group = group;
        this.executionContext = executionContext;
        Connection.$init$((Connection)this);
        TimeoutScheduler.$init$((TimeoutScheduler)this);
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, group, executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.preparedStatementsCounter = new AtomicInteger();
        this.parameterStatus = new HashMap();
        this.parsedStatements = new HashMap();
        this.authenticated = false;
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.notifyListeners = new CopyOnWriteArrayList();
        this.queryResult = None$.MODULE$;
    }
}

