/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.column;

import com.github.mauricio.async.db.column.ColumnDecoder;
import com.github.mauricio.async.db.column.ColumnEncoder;
import com.github.mauricio.async.db.column.ColumnEncoderDecoder;
import com.github.mauricio.async.db.exceptions.DateEncoderNotAvailableException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.util.Log$;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class PostgreSQLTimestampEncoderDecoder$
implements ColumnEncoderDecoder {
    public static PostgreSQLTimestampEncoderDecoder$ MODULE$;
    private final Logger log;
    private final DateTimeParser optionalTimeZone;
    private final IndexedSeq<DateTimeFormatter> internalFormatters;
    private final DateTimeFormatter internalFormatterWithoutSeconds;

    static {
        new PostgreSQLTimestampEncoderDecoder$();
    }

    private Logger log() {
        return this.log;
    }

    private DateTimeParser optionalTimeZone() {
        return this.optionalTimeZone;
    }

    private IndexedSeq<DateTimeFormatter> internalFormatters() {
        return this.internalFormatters;
    }

    private DateTimeFormatter internalFormatterWithoutSeconds() {
        return this.internalFormatterWithoutSeconds;
    }

    public DateTimeFormatter formatter() {
        return (DateTimeFormatter)this.internalFormatters().apply(5);
    }

    public Object decode(ColumnData kind, ByteBuf value, Charset charset) {
        LocalDateTime localDateTime;
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        String text = new String(bytes, charset);
        PostgreSQLColumnData columnType = (PostgreSQLColumnData)kind;
        int n = columnType.dataType();
        switch (n) {
            case 1114: 
            case 1115: {
                localDateTime = this.selectFormatter(text).parseLocalDateTime(text);
                break;
            }
            case 1185: {
                localDateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            case 1184: {
                if (columnType.dataTypeModifier() > 0) {
                    localDateTime = ((DateTimeFormatter)this.internalFormatters().apply(columnType.dataTypeModifier() - 1)).parseDateTime(text);
                    break;
                }
                localDateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return localDateTime;
    }

    private DateTimeFormatter selectFormatter(String text) {
        return text.contains(".") ? (DateTimeFormatter)this.internalFormatters().apply(5) : this.internalFormatterWithoutSeconds();
    }

    public Object decode(String value) {
        throw new UnsupportedOperationException("this method should not have been called");
    }

    public String encode(Object value) {
        String string;
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = this.formatter().print((ReadableInstant)new DateTime((Object)timestamp));
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = this.formatter().print((ReadableInstant)new DateTime((Object)date));
        } else if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            string = this.formatter().print((ReadableInstant)new DateTime((Object)calendar));
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            string = this.formatter().print((ReadablePartial)localDateTime);
        } else if (object instanceof ReadableDateTime) {
            ReadableDateTime readableDateTime = (ReadableDateTime)object;
            string = this.formatter().print((ReadableInstant)readableDateTime);
        } else {
            throw new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    public boolean supportsStringDecoding() {
        return false;
    }

    public static final /* synthetic */ DateTimeFormatter $anonfun$internalFormatters$1(PostgreSQLTimestampEncoderDecoder$ $this, int index) {
        return new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendPattern("." + new StringOps(Predef$.MODULE$.augmentString("S")).$times(index)).appendOptional($this.optionalTimeZone()).toFormatter();
    }

    private PostgreSQLTimestampEncoderDecoder$() {
        MODULE$ = this;
        ColumnEncoder.$init$((ColumnEncoder)this);
        ColumnDecoder.$init$((ColumnDecoder)this);
        this.log = Log$.MODULE$.getByName(this.getClass().getName());
        this.optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("Z").toParser();
        this.internalFormatters = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 6).inclusive().map((Function1 & Serializable & scala.Serializable)index -> PostgreSQLTimestampEncoderDecoder$.$anonfun$internalFormatters$1(this, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        this.internalFormatterWithoutSeconds = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(this.optionalTimeZone()).toFormatter();
    }
}

