/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.util;

import com.github.mauricio.async.db.postgresql.exceptions.InvalidArrayException;
import com.github.mauricio.async.db.postgresql.util.ArrayStreamingParserDelegate;
import com.github.mauricio.async.db.util.Log$;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ArrayStreamingParser$ {
    public static ArrayStreamingParser$ MODULE$;
    private final Logger log;

    static {
        new ArrayStreamingParser$();
    }

    public Logger log() {
        return this.log;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(String content, ArrayStreamingParserDelegate delegate) {
        boolean escaping = false;
        boolean quoted = false;
        StringBuilder currentElement = null;
        int opens = 0;
        int closes = 0;
        block7: for (int index = 0; index < new StringOps(Predef$.MODULE$.augmentString(content)).size(); ++index) {
            BoxedUnit boxedUnit;
            char c = content.charAt(index);
            if (escaping) {
                currentElement.append(c);
                escaping = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            char c2 = c;
            switch (c2) {
                case '{': {
                    if (quoted) break;
                    delegate.arrayStarted();
                    ++opens;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case '}': {
                    if (quoted) break;
                    if (currentElement != null) {
                        this.sendElementEvent(currentElement, quoted, delegate);
                        currentElement = null;
                    }
                    delegate.arrayEnded();
                    ++closes;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case '\"': {
                    if (quoted) {
                        this.sendElementEvent(currentElement, quoted, delegate);
                        currentElement = null;
                        quoted = false;
                    } else {
                        quoted = true;
                        currentElement = new StringBuilder();
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case ',': {
                    if (quoted) break;
                    if (currentElement != null) {
                        this.sendElementEvent(currentElement, quoted, delegate);
                    }
                    currentElement = null;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
                case '\\': {
                    escaping = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block7;
                }
            }
            if (currentElement == null) {
                currentElement = new StringBuilder();
            }
            boxedUnit = currentElement.append(c);
        }
        if (opens != closes) {
            throw new InvalidArrayException(new StringOps(Predef$.MODULE$.augmentString("This array is unbalanced %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{content})));
        }
    }

    public void sendElementEvent(StringBuilder builder, boolean quoted, ArrayStreamingParserDelegate delegate) {
        String value = builder.toString();
        if (!quoted && "NULL".equalsIgnoreCase(value)) {
            delegate.nullElementFound();
        } else {
            delegate.elementFound(value);
        }
    }

    private ArrayStreamingParser$() {
        MODULE$ = this;
        this.log = Log$.MODULE$.getByName(this.getClass().getName());
    }
}

